<?php
// Demo: Dati delle liste dei partiti
$liste = [
    ["nome" => "Partito A", "percentuale" => 25.3, "simbolo" => "https://picsum.photos/50"],
    ["nome" => "Partito B", "percentuale" => 18.7, "simbolo" => "https://picsum.photos/50"],
    ["nome" => "Partito C", "percentuale" => 12.5, "simbolo" => "https://picsum.photos/50"],
    ["nome" => "Partito D", "percentuale" => 8.9, "simbolo" => "https://picsum.photos/50"],
    ["nome" => "Partito E", "percentuale" => 7.4, "simbolo" => "https://picsum.photos/50"],
];
?>

<div class="container my-4">
    <div class="table-responsive">
        <table class="table table-striped align-middle">
            <tbody>
                <?php foreach ($liste as $lista): ?>
                    <tr class="row-spacing">
                        <td class="text-start px-5">
                            <img src="<?= htmlspecialchars($lista['simbolo']); ?>" alt="<?= htmlspecialchars($lista['nome']); ?>" class="img-simbolo">
                        </td>
                        <td class="text-center"><strong><?= htmlspecialchars($lista['nome']); ?></strong></td>
                        <td class="text-end px-5"><strong><?= number_format($lista['percentuale'], 1); ?>%</strong></td>
                    </tr>
                    <tr class="row-spacing-empty">
                        <td colspan="3"></td> <!-- Riga vuota tra le righe -->
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- CSS -->
<style>
  .img-simbolo {
    width: 40px;
    height: 40px;
    object-fit: cover;
    border-radius: 50%; /* Simbolo circolare */
    border: 2px solid #D3D3D3;
  }

  .table {
    width: 100%;
    border-collapse: collapse;
  }

  .table th,
  .table td {
    vertical-align: middle;
    padding: 10px;
  }

  .table th {
    background-color: #f8f9fa;
    border-bottom: 2px solid #dee2e6;
  }

  .table tbody tr:nth-child(odd) {
    background-color: #f9f9f9;
  }

  .table tbody tr td.text-start {
    text-align: left;
  }

  .table tbody tr td.text-center {
    text-align: center;
  }

  .table tbody tr td.text-end {
    text-align: right;
  }

  .row-spacing {
    margin-bottom: 0px; /* Spaziatura tra le righe principali */
  }

  .row-spacing-empty {
    height: 20px; /* Altezza della riga vuota per separazione */
  }
</style>
