<?php
// Demo: Dati dei candidati sindaci
$candidati = [
    ["nome" => "Giovanni Rossi", "percentuale" => 45.3, "foto" => "https://picsum.photos/150"],
    ["nome" => "Maria Bianchi", "percentuale" => 30.2, "foto" => "https://picsum.photos/150"],
    ["nome" => "Luigi Verdi", "percentuale" => 15.8, "foto" => "https://picsum.photos/150"],
    ["nome" => "Anna Neri", "percentuale" => 8.7, "foto" => "https://picsum.photos/150"],
    ["nome" => "Marco Gialli", "percentuale" => 25.5, "foto" => "https://picsum.photos/150"],
    ["nome" => "Luca Fiori", "percentuale" => 12.0, "foto" => "https://picsum.photos/150"],
];
?>

<div class="container my-4">
    <div class="row">
        <?php foreach ($candidati as $candidato): ?>
            <div class="col-2 mb-4"> <!-- Usa col-2 per gestire l'area fissa, senza responsività -->
                <div class="card text-center shadow-sm candidato-card">
                    <div class="img-container">
                        <img src="<?= htmlspecialchars($candidato['foto']); ?>" class="card-img-top candidato-img" alt="<?= htmlspecialchars($candidato['nome']); ?>">
                    </div>
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($candidato['nome']); ?></h5>
                        <p class="card-text">
                            <strong><?= number_format($candidato['percentuale'], 1); ?>%</strong>
                        </p>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- CSS aggiornato -->
<style>
  .img-container {
    width: 100px;
    height: 90px; /* Ridotto leggermente il quadrato per eliminare spazio */
    overflow: hidden;
    margin-left: auto;
    margin-right: auto;
    margin-top: 10px; /* Stacca la foto dal bordo superiore */
  }

  .candidato-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }

  .row {
    display: flex;
    justify-content: space-evenly;
    flex-wrap: nowrap;
  }

  .col-2 {
    flex: 0 0 16.66%;
    padding: 0;
  }

  .candidato-card {
    margin: 0;
    padding: 0;
    height: 100%;
    border: 2px solid #D3D3D3;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  }

  .card-body {
    padding: 10px;
  }

  .card-body .card-title {
    margin-bottom: 5px; /* Rimuove lo spazio extra sotto il nome */
  }

  .card-body .card-text {
    margin-bottom: 0; /* Rimuove lo spazio sotto la percentuale */
    line-height: 1; /* Compatta ancora di più lo spazio */
  }

  .col-2:not(:last-child) {
    margin-right: 15px;
  }
</style>
