<?php
/************************************************************************/
/* Eleonline - Raccolta e diffusione dei dati elettorali                */
/* Funzione di import dati da DAIT										*/
/* by Roberto Gigli & Alessandro Candido                                */
/* http://www.eleonline.it                                              */
/* info@eleonline.it 									                */
/************************************************************************/
/* Amministrazione                                                      */
/************************************************************************/

if (!defined('ADMIN_FILE')) {
    die ("You can't access this file directly...");
}
$perms=ChiSei(0);
if ($perms<32) die("Non hai i permessi per effettuare questa operazione!");
$language=$_SESSION['lang'];
$param=strtolower($_SERVER['REQUEST_METHOD']) == 'get' ? $_GET : $_POST;
$id_cons_gen=intval($param['id_cons_gen']);
global $id_comune,$tipo_cons;
$sql="select id_cons from ".$prefix."_ele_cons_comune where id_cons_gen='$id_cons_gen' and id_comune='$id_comune'";
$res = $dbi->prepare("$sql");
$res->execute();	
list($idcns)=$res->fetch(PDO::FETCH_NUM);
include("modules/Elezioni/ele.php");

// Variabili di controllo
$fileUrl = isset($_POST['file_url']) ? $_POST['file_url'] : "";
$circoscrizione = isset($_POST['circoscrizione']) ? $_POST['circoscrizione'] : "";
$collegio = isset($_POST['collegio']) ? $_POST['collegio'] : "";
$confermaDati = isset($_POST['conferma_dati']) ? $_POST['conferma_dati'] : "";
$csvData = [];
$circoscrizioni = [];
$collegi = [];
$filteredData = [];

// Funzione per scaricare il file CSV
function downloadCSV($url) {
	$posuni = strrpos($url,'_uni.csv',0);
	$pospluri = strrpos($url,'_pluri.csv',0);
	if(!$posuni && !$pospluri) exit;
	elseif(!$posuni){
		$urluni=str_replace('_pluri.csv','_uni.csv',$url);
		$urlpluri=$url;
	}else{
		$urluni=$url;
		$urlpluri=str_replace('_uni.csv','_pluri.csv',$url);		
	}
    $data = file_get_contents($urluni);
    $ar[0] = explode("\n", $data);
    $data = file_get_contents($urlpluri);
    $ar[1] = explode("\n", $data);
	foreach ($ar[0] as $lineuni) 
	if ($lineuni) {
		$csvData[0][]=str_getcsv($lineuni);
	}
	foreach ($ar[1] as $linepluri) 
	if ($linepluri) {
		$csvData[1][]=str_getcsv($linepluri);
	}	
    return $csvData;
}	
function filtradati($csvData)
{
#più collegi uninominali in un collegio plurinominale
	global $collegio,$tipo_cons;
	if($tipo_cons==7 or $tipo_cons==10 or $tipo_cons==16 or $tipo_cons==19)
		$corrispondenza=file_get_contents("modules/Elezioni/collegi_senato.txt");
	else
		$corrispondenza=file_get_contents("modules/Elezioni/collegi_camera.txt");
	$tmp=explode("\n",$corrispondenza);
	foreach($tmp as $val){
		$collegicamera[]=explode("\t",strtoupper($val));
	}
    $filtrato = array();
	foreach($collegicamera as $key=>$val)
	{
		if(strncmp($collegio,$val[1],strlen($val[1]))) { continue; } 
		$collegiuni[]=$val[1]; 
		$collegipluri[]=$val[0];
		foreach($csvData[0] as $index => $string) {
			$pos=strncmp($string[1], $val[1], strlen($val[1]));
			if ( $pos !== 0 or $string[0]!='ITALIA' )
				continue;
			$filtrato[]=array($string[3],$string[2]);
		}		
	}
if(!isset($filtrato) or (isset($filtrato) and count($filtrato)==0)) { 
	$linesuni=$csvData[0];
	$linespluri=$csvData[1];
	$i=0;$y=0;
    foreach ($linesuni as $lineuni) { $i++;
			if($lineuni[1]!=$collegio or $lineuni[2]=='DESCR_LISTA') continue;
			foreach($linespluri as $linepluri)
			{ 
				$y++;
				$flag=0;
				foreach($collegipluri as $tmpcollegio) {
					if($linepluri[1]==$tmpcollegio and $lineuni[2]==$linepluri[2]) { $flag=1;}
				}
				if(!$flag) continue;
				if(isset($lineuni[2]) and isset($linepluri[2])){ # and strrpos($lineuni[2],$linepluri[2],0)
					$filtrato[] = array($lineuni[3],$linepluri[2],$linepluri[3]);
				}
			}
		}
	}	
    return $filtrato;
}

if (!empty($fileUrl)) {
    $csvData = downloadCSV($fileUrl);
    $header = $csvData[0][0]; // Intestazione delle colonne

    // Trova le posizioni delle colonne
    $circoscrizioneColIndex = array_search('CIRCOSCRIZIONE', $header);
    $collegioColIndex = array_search('COLLEGIO_UNINOMINALE', $header);
    // Estrai i valori unici per le circoscrizioni
    foreach ($csvData[0] as $row) {
        if (isset($row[$circoscrizioneColIndex]) && !in_array($row[$circoscrizioneColIndex], $circoscrizioni)) {
            $circoscrizioni[] = $row[$circoscrizioneColIndex];
        }
    }

    // Estrai i valori unici per i collegi se una circoscrizione è selezionata
    if (!empty($circoscrizione)) {
        foreach ($csvData[0] as $row) {
            if (isset($row[$circoscrizioneColIndex]) && $row[$circoscrizioneColIndex] === $circoscrizione) {
                if (!in_array($row[$collegioColIndex], $collegi)) {
                    $collegi[] = $row[$collegioColIndex];
                }
            }
        }
    }

    // Filtra i dati in base alla circoscrizione e al collegio selezionati
    if (!empty($collegio)) {
		$filteredData=filtradati($csvData);
    }
}

// Gestisci il clic su "No" per resettare la visualizzazione dei dati
if ($confermaDati === "no") {
    // Resetta il filtro e ricarica la pagina
    $circoscrizione = "";
    $collegio = "";
    $filteredData = [];
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filtra per Circoscrizione e Collegio</title>
    <style>
        .hidden { display: none; }
        .form-section { margin-bottom: 20px; }
        .form-container { display: flex; gap: 10px; align-items: center; }
        button { padding: 10px 20px; cursor: pointer; }
        #data-section { display: none; }
    </style>
    <script>
        function showTable() {
            document.getElementById('form-section').style.display = 'none';
            document.getElementById('data-section').style.display = 'block';
        }

        window.onload = function() {
            <?php if (!empty($circoscrizione) && !empty($collegio)): ?>
                showTable();
            <?php endif; ?>
        }
    </script>
</head>
<body>

<?php if ($confermaDati === "si"){ 	
	$sql="delete from ".$prefix."_ele_gruppo where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$sql="delete from ".$prefix."_ele_voti_gruppo where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$sql="delete from ".$prefix."_ele_lista where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$sql="delete from ".$prefix."_ele_voti_lista where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$sql="delete from ".$prefix."_ele_candidati where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$sql="delete from ".$prefix."_ele_voti_candidati where id_cons='$idcns'";
	$reslnew = $dbi->prepare("$sql");
	$reslnew->execute();	
	$gruppo='';
	$numgruppo=1;
	$lista='';
	$numlista=1;#	echo "TEST1: ".count($filteredData);
	foreach ($filteredData as $row){
		if($gruppo!=$row[0]){
			$gruppo=$row[0];
			$valori = $idcns.", null,'".$numgruppo."',".$dbi->quote($row[0]).",'','','0','0','',null,'','','0','0'"; 
			$sql="insert into ".$prefix."_ele_gruppo values($valori)";#echo "<br>TEST: $valori";
			try {
				$res_gruppo = $dbi->prepare("$sql");
				$res_gruppo->execute();
			}
			catch(PDOException $e)
			{
				ele();
				echo "<br>sql:".$sql . "<br>" . $e->getMessage();
				unset($valori);
				die();
			}                  
			$sql="select id_gruppo,num_gruppo from ".$prefix."_ele_gruppo where num_gruppo='".$numgruppo++."' and id_cons='$idcns'";
			$reslnew = $dbi->prepare("$sql");
			$reslnew->execute();	
			list ($newidg,$newnumg) = $reslnew->fetch(PDO::FETCH_NUM);
			unset($valori);
		}	
		if($lista!=$row[1]){
			$lista=$row[1];
			$numcand=1;
			$valori = $idcns.", null,'".$numlista."','$newidg','$newnumg','0','0',".$dbi->quote($row[1]).",'',null,''";
			$sql="insert into ".$prefix."_ele_lista values($valori)"; #echo "<br>TEST: $valori";
			try {
				$res_lista = $dbi->prepare("$sql");
				$res_lista->execute();
			}
			catch(PDOException $e)
			{
				ele();
				echo "<br>sql:".$sql . "<br>" . $e->getMessage();
				unset($valori);
				die();
			}                  
				
			$sql="select id_lista,num_lista from ".$prefix."_ele_lista where num_lista='".$numlista++."' and id_cons='$idcns'";
			$reslnew = $dbi->prepare("$sql");
			$reslnew->execute();	
			list ($newidl,$newnuml) = $reslnew->fetch(PDO::FETCH_NUM);
			unset($valori);
		}
		if(!isset($row[2])) continue;
		$valori="null,'$idcns','$newidl','$newnuml',".$dbi->quote($row[2]).",'','','','".$numcand++."','','','0'";
		$sql="insert into ".$prefix."_ele_candidati values($valori)";  #die("VAL:$sql");
		try {
			$res_lista = $dbi->prepare("$sql");
			$res_lista->execute();
		}
		catch(PDOException $e)
		{
				ele();
				echo "<br>sql:".$sql . "<br>" . $e->getMessage();
				unset($valori);
				die();
		}                  
		unset($valori);
	}
	Header("Location: admin.php?op=gruppo&id_cons_gen=$id_cons_gen");
}
ele();
?>
<?php if (empty($confermaDati) || $confermaDati === "no"): ?>
<?php $sql="SELECT tipo_cons FROM ".$prefix."_ele_consultazione where id_cons_gen=$id_cons_gen";
	$sth = $dbi->prepare("$sql");
	$sth->execute();
	list($tipocons)=$sth->fetch(PDO::FETCH_NUM);
	if ($tipocons==6 || $tipocons==11 || $tipocons==15 || $tipocons==18) $descr="Camera"; 
	if ($tipocons==7 || $tipocons==10 || $tipocons==16 || $tipocons==19) $descr="Senato"; 
?>
    <div id="form-section">
	<h2>Importa da DAIT per consultazione: <?php echo $descr ?> </h2>
	<h2>Procedura per scaricare Liste e Candidati:</h2>
	<h3> 1 - Andare sul sito del Ministero dell'interno nell'Elenco Trasparenza link: <a href="https://dait.interno.gov.it/elezioni/trasparenza" target="_blank">https://dait.interno.gov.it/elezioni/trasparenza</a> <br>
	2 - Entra nella pagina dell'elezione da caricare<br>
	3 - Verificare se ci sono i contrassegni e salvarli in una cartella<br>
	4 - Andare su Lista e Candidati e copiare il link del file.csv<br>
	5 - Procedere secondo le indicazioni</h3>
        <h2>Inserisci il link del CSV e scegli i filtri</h2>
        <form method="post" id="filter-form"  action="admin.php">
            <div class="form-section form-container">
                <label for="file_url">Link del file CSV:</label>
				<input type="hidden" name="op" value="importadait">
				<input type="hidden" name="id_cons_gen" value="<?php echo $id_cons_gen; ?>">
                <input type="text" id="file_url" name="file_url" value="<?php echo htmlspecialchars($fileUrl); ?>" required>
                <button type="submit" name="carica_dati" value="carica">Carica</button>
            </div>

            <?php if (!empty($fileUrl) && !empty($csvData[0])): ?>
                <div class="form-section">
                    <label for="circoscrizione">Seleziona una Circoscrizione:</label>
                    <select id="circoscrizione" name="circoscrizione" onchange="this.form.submit()">
                        <option value="">-- Seleziona una Circoscrizione --</option>
                        <?php foreach ($circoscrizioni as $circ): ?>
                            <option value="<?php echo htmlspecialchars($circ); ?>" <?php echo ($circ === $circoscrizione) ? "selected" : ""; ?>><?php echo htmlspecialchars($circ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php if (!empty($circoscrizione)): ?>
                    <div class="form-section">
                        <label for="collegio">Seleziona un Collegio:</label>
                        <select id="collegio" name="collegio" onchange="this.form.submit()">
                            <option value="">-- Seleziona un Collegio --</option>
                            <?php foreach ($collegi as $coll): ?>
                                <option value="<?php echo htmlspecialchars($coll); ?>" <?php echo ($coll === $collegio) ? "selected" : ""; ?>><?php echo htmlspecialchars($coll); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </form>
    </div>
<?php endif; ?>

<?php if (!empty($collegio) && !empty($filteredData)): ?>
    <div id="data-section">
        <form method="post"  action="admin.php">
			<input type="hidden" name="op" value="importadait">
			<input type="hidden" name="id_cons_gen" value="<?php echo $id_cons_gen; ?>">
            <input type="hidden" name="file_url" value="<?php echo htmlspecialchars($fileUrl); ?>">
            <input type="hidden" name="circoscrizione" value="<?php echo htmlspecialchars($circoscrizione); ?>">
            <input type="hidden" name="collegio" value="<?php echo htmlspecialchars($collegio); ?>">
            <p><strong>I dati sono corretti?</strong></p>
            <button type="submit" name="conferma_dati" value="si">Sì</button>
            <button type="submit" name="conferma_dati" value="no">No</button>
        </form>

        <h3>Dati filtrati per Collegio: <?php echo htmlspecialchars($collegio); ?></h3>
        <table border="1">
            <tr>
                <?php 
                $excludeColumns = ['CIRCOSCRIZIONE', 'COLLEGIO_PLURINOMINALE']; #
				$header=['CANDIDATO UNINOMINALE', 'LISTA','CANDIDATI PLURINOMINALE'];
                foreach ($header as $colName): 
                    if (!in_array($colName, $excludeColumns)):
                ?>
                        <th><?php echo htmlspecialchars($colName); ?></th>
                <?php 
                    endif;
                endforeach;
                ?>
            </tr>
            <?php foreach ($filteredData as $row): ?>
                <tr>
                    <?php 
                    foreach ($row as $index => $cell): 
                        if (!in_array($header[$index], $excludeColumns)): 
                    ?>
                            <td><?php echo htmlspecialchars($cell); ?></td>
                    <?php 
                        endif;
                    endforeach;
                    ?>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
<?php endif; ?>


</body>
</html>
